package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 分摊规则明细feign客户端
 *
 * @author ultraman
 * @date 2021-12-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.AllocationRuleDetails;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface AllocationRuleDetailsFeignApi {

  /**
   * 通过id查询分摊规则明细
   * @param  id
   * @return R
   */
  @GetMapping("/allocationRuleDetails/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增分摊规则明细
   * @param allocationRuleDetails 分摊规则明细
   * @return R
   */
  @PostMapping("/allocationRuleDetails/add")
  public R save(@RequestBody AllocationRuleDetails allocationRuleDetails);

  /**
   * 修改分摊规则明细
   * @param allocationRuleDetails 分摊规则明细
   * @return R
   */
  @PostMapping("/allocationRuleDetails/update")
  public R updateById(@RequestBody AllocationRuleDetails allocationRuleDetails);

  /**
   * 通过id删除分摊规则明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/allocationRuleDetails/del/{id}" )
  public R removeById(@PathVariable Long id);

}