package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 合同裸数据feign客户端
 *
 * @author ultraman
 * @date 2021-12-09
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ContractRawData;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ContractRawDataFeignApi {

  /**
   * 通过id查询合同裸数据
   * @param  id
   * @return R
   */
  @GetMapping("/contractRawData/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增合同裸数据
   * @param contractRawData 合同裸数据
   * @return R
   */
  @PostMapping("/contractRawData/add")
  public R save(@RequestBody ContractRawData contractRawData);

  /**
   * 修改合同裸数据
   * @param contractRawData 合同裸数据
   * @return R
   */
  @PostMapping("/contractRawData/update")
  public R updateById(@RequestBody ContractRawData contractRawData);

  /**
   * 通过id删除合同裸数据
   * @param  id
   * @return R
   */
  @DeleteMapping("/contractRawData/del/{id}" )
  public R removeById(@PathVariable Long id);

}