package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 发票数据feign客户端
 *
 * @author ultraman
 * @date 2021-12-28
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.InvoiceData;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface InvoiceDataFeignApi {

  /**
   * 通过id查询发票数据
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceData/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票数据
   * @param invoiceData 发票数据
   * @return R
   */
  @PostMapping("/invoiceData/add")
  public R save(@RequestBody InvoiceData invoiceData);

  /**
   * 修改发票数据
   * @param invoiceData 发票数据
   * @return R
   */
  @PostMapping("/invoiceData/update")
  public R updateById(@RequestBody InvoiceData invoiceData);

  /**
   * 通过id删除发票数据
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceData/del/{id}" )
  public R removeById(@PathVariable Long id);

}