package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 税号清单feign客户端
 *
 * @author ultraman
 * @date 2021-12-28
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.TaxNoList;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface TaxNoListFeignApi {

  /**
   * 通过id查询税号清单
   * @param  id
   * @return R
   */
  @GetMapping("/taxNoList/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增税号清单
   * @param taxNoList 税号清单
   * @return R
   */
  @PostMapping("/taxNoList/add")
  public R save(@RequestBody TaxNoList taxNoList);

  /**
   * 修改税号清单
   * @param taxNoList 税号清单
   * @return R
   */
  @PostMapping("/taxNoList/update")
  public R updateById(@RequestBody TaxNoList taxNoList);

  /**
   * 通过id删除税号清单
   * @param  id
   * @return R
   */
  @DeleteMapping("/taxNoList/del/{id}" )
  public R removeById(@PathVariable Long id);

}