package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 发票裸数据feign客户端
 *
 * @author ultraman
 * @date 2021-12-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.InvoiceRawData;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface InvoiceRawDataFeignApi {

  /**
   * 通过id查询发票裸数据
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceRawData/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票裸数据
   * @param invoiceRawData 发票裸数据
   * @return R
   */
  @PostMapping("/invoiceRawData/add")
  public R save(@RequestBody InvoiceRawData invoiceRawData);

  /**
   * 修改发票裸数据
   * @param invoiceRawData 发票裸数据
   * @return R
   */
  @PostMapping("/invoiceRawData/update")
  public R updateById(@RequestBody InvoiceRawData invoiceRawData);

  /**
   * 通过id删除发票裸数据
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceRawData/del/{id}" )
  public R removeById(@PathVariable Long id);

}