package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 结算对账单数据feign客户端
 *
 * @author ultraman
 * @date 2022-02-26
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ReconciliationData;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ReconciliationDataFeignApi {

  /**
   * 通过id查询结算对账单数据
   * @param  id
   * @return R
   */
  @GetMapping("/reconciliationData/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增结算对账单数据
   * @param reconciliationData 结算对账单数据
   * @return R
   */
  @PostMapping("/reconciliationData/add")
  public R save(@RequestBody ReconciliationData reconciliationData);

  /**
   * 修改结算对账单数据
   * @param reconciliationData 结算对账单数据
   * @return R
   */
  @PostMapping("/reconciliationData/update")
  public R updateById(@RequestBody ReconciliationData reconciliationData);

  /**
   * 通过id删除结算对账单数据
   * @param  id
   * @return R
   */
  @DeleteMapping("/reconciliationData/del/{id}" )
  public R removeById(@PathVariable Long id);

}