package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 业务招待报销单明细feign客户端
 *
 * @author ultraman
 * @date 2022-06-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.BusinessServeBillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface BusinessServeBillDetailFeignApi {

  /**
   * 通过id查询业务招待报销单明细
   * @param  id
   * @return R
   */
  @GetMapping("/businessServeBillDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务招待报销单明细
   * @param businessServeBillDetail 业务招待报销单明细
   * @return R
   */
  @PostMapping("/businessServeBillDetail/add")
  public R save(@RequestBody BusinessServeBillDetail businessServeBillDetail);

  /**
   * 修改业务招待报销单明细
   * @param businessServeBillDetail 业务招待报销单明细
   * @return R
   */
  @PostMapping("/businessServeBillDetail/update")
  public R updateById(@RequestBody BusinessServeBillDetail businessServeBillDetail);

  /**
   * 通过id删除业务招待报销单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/businessServeBillDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}