package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 差旅申请单feign客户端
 *
 * @author ultraman
 * @date 2022-06-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.TravelApplyBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface TravelApplyBillFeignApi {

  /**
   * 通过id查询差旅申请单
   * @param  id
   * @return R
   */
  @GetMapping("/travelApplyBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增差旅申请单
   * @param travelApplyBill 差旅申请单
   * @return R
   */
  @PostMapping("/travelApplyBill/add")
  public R save(@RequestBody TravelApplyBill travelApplyBill);

  /**
   * 修改差旅申请单
   * @param travelApplyBill 差旅申请单
   * @return R
   */
  @PostMapping("/travelApplyBill/update")
  public R updateById(@RequestBody TravelApplyBill travelApplyBill);

  /**
   * 通过id删除差旅申请单
   * @param  id
   * @return R
   */
  @DeleteMapping("/travelApplyBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}