package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 核销基础单据feign客户端
 *
 * @author ultraman
 * @date 2022-06-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.WriteoffBasicBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface WriteoffBasicBillFeignApi {

  /**
   * 通过id查询核销基础单据
   * @param  id
   * @return R
   */
  @GetMapping("/writeoffBasicBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增核销基础单据
   * @param writeoffBasicBill 核销基础单据
   * @return R
   */
  @PostMapping("/writeoffBasicBill/add")
  public R save(@RequestBody WriteoffBasicBill writeoffBasicBill);

  /**
   * 修改核销基础单据
   * @param writeoffBasicBill 核销基础单据
   * @return R
   */
  @PostMapping("/writeoffBasicBill/update")
  public R updateById(@RequestBody WriteoffBasicBill writeoffBasicBill);

  /**
   * 通过id删除核销基础单据
   * @param  id
   * @return R
   */
  @DeleteMapping("/writeoffBasicBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}