package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 成本单价feign客户端
 *
 * @author ultraman
 * @date 2022-06-14
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.UnitPrice;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface UnitPriceFeignApi {

  /**
   * 通过id查询成本单价
   * @param  id
   * @return R
   */
  @GetMapping("/unitPrice/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增成本单价
   * @param unitPrice 成本单价
   * @return R
   */
  @PostMapping("/unitPrice/add")
  public R save(@RequestBody UnitPrice unitPrice);

  /**
   * 修改成本单价
   * @param unitPrice 成本单价
   * @return R
   */
  @PostMapping("/unitPrice/update")
  public R updateById(@RequestBody UnitPrice unitPrice);

  /**
   * 通过id删除成本单价
   * @param  id
   * @return R
   */
  @DeleteMapping("/unitPrice/del/{id}" )
  public R removeById(@PathVariable Long id);

}