package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 预算包feign客户端
 *
 * @author ultraman
 * @date 2022-07-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ChargeCodeBudgetPackge;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ChargeCodeBudgetPackgeFeignApi {

  /**
   * 通过id查询预算包
   * @param  id
   * @return R
   */
  @GetMapping("/chargeCodeBudgetPackge/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增预算包
   * @param chargeCodeBudgetPackge 预算包
   * @return R
   */
  @PostMapping("/chargeCodeBudgetPackge/add")
  public R save(@RequestBody ChargeCodeBudgetPackge chargeCodeBudgetPackge);

  /**
   * 修改预算包
   * @param chargeCodeBudgetPackge 预算包
   * @return R
   */
  @PostMapping("/chargeCodeBudgetPackge/update")
  public R updateById(@RequestBody ChargeCodeBudgetPackge chargeCodeBudgetPackge);

  /**
   * 通过id删除预算包
   * @param  id
   * @return R
   */
  @DeleteMapping("/chargeCodeBudgetPackge/del/{id}" )
  public R removeById(@PathVariable Long id);

}