package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 废弃feign客户端
 *
 * @author ultraman
 * @date 2022-07-16
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.AllocationByTaxNo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface AllocationByTaxNoFeignApi {

  /**
   * 通过id查询废弃
   * @param  id
   * @return R
   */
  @GetMapping("/allocationByTaxNo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增废弃
   * @param allocationByTaxNo 废弃
   * @return R
   */
  @PostMapping("/allocationByTaxNo/add")
  public R save(@RequestBody AllocationByTaxNo allocationByTaxNo);

  /**
   * 修改废弃
   * @param allocationByTaxNo 废弃
   * @return R
   */
  @PostMapping("/allocationByTaxNo/update")
  public R updateById(@RequestBody AllocationByTaxNo allocationByTaxNo);

  /**
   * 通过id删除废弃
   * @param  id
   * @return R
   */
  @DeleteMapping("/allocationByTaxNo/del/{id}" )
  public R removeById(@PathVariable Long id);

}