package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 废弃feign客户端
 *
 * @author ultraman
 * @date 2022-08-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.AllocationByOrder;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface AllocationByOrderFeignApi {

  /**
   * 通过id查询废弃
   * @param  id
   * @return R
   */
  @GetMapping("/allocationByOrder/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增废弃
   * @param allocationByOrder 废弃
   * @return R
   */
  @PostMapping("/allocationByOrder/add")
  public R save(@RequestBody AllocationByOrder allocationByOrder);

  /**
   * 修改废弃
   * @param allocationByOrder 废弃
   * @return R
   */
  @PostMapping("/allocationByOrder/update")
  public R updateById(@RequestBody AllocationByOrder allocationByOrder);

  /**
   * 通过id删除废弃
   * @param  id
   * @return R
   */
  @DeleteMapping("/allocationByOrder/del/{id}" )
  public R removeById(@PathVariable Long id);

}