package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 资产的领用及更换申请单明细feign客户端
 *
 * @author ultraman
 * @date 2022-08-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialAssetsBillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialAssetsBillDetailFeignApi {

  /**
   * 通过id查询资产的领用及更换申请单明细
   * @param  id
   * @return R
   */
  @GetMapping("/financialAssetsBillDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增资产的领用及更换申请单明细
   * @param financialAssetsBillDetail 资产的领用及更换申请单明细
   * @return R
   */
  @PostMapping("/financialAssetsBillDetail/add")
  public R save(@RequestBody FinancialAssetsBillDetail financialAssetsBillDetail);

  /**
   * 修改资产的领用及更换申请单明细
   * @param financialAssetsBillDetail 资产的领用及更换申请单明细
   * @return R
   */
  @PostMapping("/financialAssetsBillDetail/update")
  public R updateById(@RequestBody FinancialAssetsBillDetail financialAssetsBillDetail);

  /**
   * 通过id删除资产的领用及更换申请单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialAssetsBillDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}