package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 日常报销单feign客户端
 *
 * @author ultraman
 * @date 2022-08-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialDailyBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialDailyBillFeignApi {

  /**
   * 通过id查询日常报销单
   * @param  id
   * @return R
   */
  @GetMapping("/financialDailyBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增日常报销单
   * @param financialDailyBill 日常报销单
   * @return R
   */
  @PostMapping("/financialDailyBill/add")
  public R save(@RequestBody FinancialDailyBill financialDailyBill);

  /**
   * 修改日常报销单
   * @param financialDailyBill 日常报销单
   * @return R
   */
  @PostMapping("/financialDailyBill/update")
  public R updateById(@RequestBody FinancialDailyBill financialDailyBill);

  /**
   * 通过id删除日常报销单
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialDailyBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}