package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2022-08-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.OrderInvoiceImportData;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface OrderInvoiceImportDataFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/orderInvoiceImportData/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param orderInvoiceImportData ${table.comment}
   * @return R
   */
  @PostMapping("/orderInvoiceImportData/add")
  public R save(@RequestBody OrderInvoiceImportData orderInvoiceImportData);

  /**
   * 修改${table.comment}
   * @param orderInvoiceImportData ${table.comment}
   * @return R
   */
  @PostMapping("/orderInvoiceImportData/update")
  public R updateById(@RequestBody OrderInvoiceImportData orderInvoiceImportData);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderInvoiceImportData/del/{id}" )
  public R removeById(@PathVariable Long id);

}