package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 分摊规则feign客户端
 *
 * @author ultraman
 * @date 2022-08-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.AllocationRule;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface AllocationRuleFeignApi {

  /**
   * 通过id查询分摊规则
   * @param  id
   * @return R
   */
  @GetMapping("/allocationRule/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增分摊规则
   * @param allocationRule 分摊规则
   * @return R
   */
  @PostMapping("/allocationRule/add")
  public R save(@RequestBody AllocationRule allocationRule);

  /**
   * 修改分摊规则
   * @param allocationRule 分摊规则
   * @return R
   */
  @PostMapping("/allocationRule/update")
  public R updateById(@RequestBody AllocationRule allocationRule);

  /**
   * 通过id删除分摊规则
   * @param  id
   * @return R
   */
  @DeleteMapping("/allocationRule/del/{id}" )
  public R removeById(@PathVariable Long id);

}