package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 保管人变更申请单feign客户端
 *
 * @author ultraman
 * @date 2022-08-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialKeeperChangeBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialKeeperChangeBillFeignApi {

  /**
   * 通过id查询保管人变更申请单
   * @param  id
   * @return R
   */
  @GetMapping("/financialKeeperChangeBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增保管人变更申请单
   * @param financialKeeperChangeBill 保管人变更申请单
   * @return R
   */
  @PostMapping("/financialKeeperChangeBill/add")
  public R save(@RequestBody FinancialKeeperChangeBill financialKeeperChangeBill);

  /**
   * 修改保管人变更申请单
   * @param financialKeeperChangeBill 保管人变更申请单
   * @return R
   */
  @PostMapping("/financialKeeperChangeBill/update")
  public R updateById(@RequestBody FinancialKeeperChangeBill financialKeeperChangeBill);

  /**
   * 通过id删除保管人变更申请单
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialKeeperChangeBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}