package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 单据附件同步信息-易快报feign客户端
 *
 * @author ultraman
 * @date 2022-08-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.BillAttachmentSyn;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface BillAttachmentSynFeignApi {

  /**
   * 通过id查询单据附件同步信息-易快报
   * @param  id
   * @return R
   */
  @GetMapping("/billAttachmentSyn/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增单据附件同步信息-易快报
   * @param billAttachmentSyn 单据附件同步信息-易快报
   * @return R
   */
  @PostMapping("/billAttachmentSyn/add")
  public R save(@RequestBody BillAttachmentSyn billAttachmentSyn);

  /**
   * 修改单据附件同步信息-易快报
   * @param billAttachmentSyn 单据附件同步信息-易快报
   * @return R
   */
  @PostMapping("/billAttachmentSyn/update")
  public R updateById(@RequestBody BillAttachmentSyn billAttachmentSyn);

  /**
   * 通过id删除单据附件同步信息-易快报
   * @param  id
   * @return R
   */
  @DeleteMapping("/billAttachmentSyn/del/{id}" )
  public R removeById(@PathVariable Long id);

}