package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * feign客户端
 *
 * @author ultraman
 * @date 2023-11-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ChargeCodeTypeCostSnapshot;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ChargeCodeTypeCostSnapshotFeignApi {

  /**
   * 通过id查询
   * @param  id
   * @return R
   */
  @GetMapping("/chargeCodeTypeCostSnapshot/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增
   * @param chargeCodeTypeCostSnapshot 
   * @return R
   */
  @PostMapping("/chargeCodeTypeCostSnapshot/add")
  public R save(@RequestBody ChargeCodeTypeCostSnapshot chargeCodeTypeCostSnapshot);

  /**
   * 修改
   * @param chargeCodeTypeCostSnapshot 
   * @return R
   */
  @PostMapping("/chargeCodeTypeCostSnapshot/update")
  public R updateById(@RequestBody ChargeCodeTypeCostSnapshot chargeCodeTypeCostSnapshot);

  /**
   * 通过id删除
   * @param  id
   * @return R
   */
  @DeleteMapping("/chargeCodeTypeCostSnapshot/del/{id}" )
  public R removeById(@PathVariable Long id);

}