package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 资产调拨转移申请单明细feign客户端
 *
 * @author ultraman
 * @date 2023-11-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialAssetsTransferBillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialAssetsTransferBillDetailFeignApi {

  /**
   * 通过id查询资产调拨转移申请单明细
   * @param  id
   * @return R
   */
  @GetMapping("/financialAssetsTransferBillDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增资产调拨转移申请单明细
   * @param financialAssetsTransferBillDetail 资产调拨转移申请单明细
   * @return R
   */
  @PostMapping("/financialAssetsTransferBillDetail/add")
  public R save(@RequestBody FinancialAssetsTransferBillDetail financialAssetsTransferBillDetail);

  /**
   * 修改资产调拨转移申请单明细
   * @param financialAssetsTransferBillDetail 资产调拨转移申请单明细
   * @return R
   */
  @PostMapping("/financialAssetsTransferBillDetail/update")
  public R updateById(@RequestBody FinancialAssetsTransferBillDetail financialAssetsTransferBillDetail);

  /**
   * 通过id删除资产调拨转移申请单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialAssetsTransferBillDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}