package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 个人借款申请单明细feign客户端
 *
 * @author ultraman
 * @date 2023-11-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialPersonLoanBillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialPersonLoanBillDetailFeignApi {

  /**
   * 通过id查询个人借款申请单明细
   * @param  id
   * @return R
   */
  @GetMapping("/financialPersonLoanBillDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增个人借款申请单明细
   * @param financialPersonLoanBillDetail 个人借款申请单明细
   * @return R
   */
  @PostMapping("/financialPersonLoanBillDetail/add")
  public R save(@RequestBody FinancialPersonLoanBillDetail financialPersonLoanBillDetail);

  /**
   * 修改个人借款申请单明细
   * @param financialPersonLoanBillDetail 个人借款申请单明细
   * @return R
   */
  @PostMapping("/financialPersonLoanBillDetail/update")
  public R updateById(@RequestBody FinancialPersonLoanBillDetail financialPersonLoanBillDetail);

  /**
   * 通过id删除个人借款申请单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialPersonLoanBillDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}