package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * 退款申请单feign客户端
 *
 * @author ultraman
 * @date 2024-03-04
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialRefundBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialRefundBillFeignApi {

  /**
   * 通过id查询退款申请单
   * @param  id
   * @return R
   */
  @GetMapping("/financialRefundBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增退款申请单
   * @param financialRefundBill 退款申请单
   * @return R
   */
  @PostMapping("/financialRefundBill/add")
  public R save(@RequestBody FinancialRefundBill financialRefundBill);

  /**
   * 修改退款申请单
   * @param financialRefundBill 退款申请单
   * @return R
   */
  @PostMapping("/financialRefundBill/update")
  public R updateById(@RequestBody FinancialRefundBill financialRefundBill);

  /**
   * 通过id删除退款申请单
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialRefundBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}