package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 *  退款申请单「其他」feign客户端
 *
 * @author ultraman
 * @date 2024-03-04
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialRfOther;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface FinancialRfOtherFeignApi {

  /**
   * 通过id查询 退款申请单「其他」
   * @param  id
   * @return R
   */
  @GetMapping("/financialRfOther/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增 退款申请单「其他」
   * @param financialRfOther  退款申请单「其他」
   * @return R
   */
  @PostMapping("/financialRfOther/add")
  public R save(@RequestBody FinancialRfOther financialRfOther);

  /**
   * 修改 退款申请单「其他」
   * @param financialRfOther  退款申请单「其他」
   * @return R
   */
  @PostMapping("/financialRfOther/update")
  public R updateById(@RequestBody FinancialRfOther financialRfOther);

  /**
   * 通过id删除 退款申请单「其他」
   * @param  id
   * @return R
   */
  @DeleteMapping("/financialRfOther/del/{id}" )
  public R removeById(@PathVariable Long id);

}