package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-09-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Contract implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("contractNo")
  private String contractNo;

  @TableField("projectNo")
  private String projectNo;

  @TableField("projectName")
  private String projectName;

  @TableField("signTeam")
  private String signTeam;

  @TableField("signatoryName")
  private String signatoryName;

  @TableField("periodPromise")
  private String periodPromise;

  @TableField("paymentPeriod")
  private Long paymentPeriod;

  @TableField("paymentPeriodType")
  private String paymentPeriodType;

  @TableField("signDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signDate;

  @TableField("effectStartTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime effectStartTime;

  @TableField("receiptSignDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiptSignDate;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("productName")
  private String productName;

  @TableField("chargeCycle")
  private String chargeCycle;

  @TableField("chargeRequirement")
  private String chargeRequirement;

  @TableField("chargeType")
  private String chargeType;

  @TableField("chargeDimension")
  private String chargeDimension;

  @TableField("chargeUnit")
  private String chargeUnit;

  @TableField("containsRetentionMoney")
  private String containsRetentionMoney;

  @TableField("chargeItem")
  private String chargeItem;

  @TableField("productCode")
  private String productCode;

  @TableField("chargeCode")
  private String chargeCode;

  @TableField("contractId")
  private String contractId;

  @TableField("uintPrice")
  private BigDecimal uintPrice;

  private BigDecimal amount;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("projectNo", projectNo);
      map.put("projectName", projectName);
      map.put("signTeam", signTeam);
      map.put("signatoryName", signatoryName);
      map.put("periodPromise", periodPromise);
      map.put("paymentPeriod", paymentPeriod);
      map.put("paymentPeriodType", paymentPeriodType);
      map.put("signDate", BocpGenUtils.toTimestamp(signDate));
      map.put("effectStartTime", BocpGenUtils.toTimestamp(effectStartTime));
      map.put("receiptSignDate", BocpGenUtils.toTimestamp(receiptSignDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("productName", productName);
      map.put("chargeCycle", chargeCycle);
      map.put("chargeRequirement", chargeRequirement);
      map.put("chargeType", chargeType);
      map.put("chargeDimension", chargeDimension);
      map.put("chargeUnit", chargeUnit);
      map.put("containsRetentionMoney", containsRetentionMoney);
      map.put("chargeItem", chargeItem);
      map.put("productCode", productCode);
      map.put("chargeCode", chargeCode);
      map.put("contractId", contractId);
      map.put("uintPrice", uintPrice);
      map.put("amount", amount);
      return map;
  }

  public static Contract fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Contract entity = new Contract();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signTeam")) {
      Object obj = map.get("signTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signatoryName")) {
      Object obj = map.get("signatoryName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignatoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("periodPromise")) {
      Object obj = map.get("periodPromise");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPeriodPromise((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPeriod")) {
      Object obj = map.get("paymentPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentPeriod((Long)obj);
        } else if(obj instanceof String) {
          entity.setPaymentPeriod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPaymentPeriod(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paymentPeriodType")) {
      Object obj = map.get("paymentPeriodType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentPeriodType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signDate")) {
      Object obj = map.get("signDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignDate(null);
      }
    }
    if(map.containsKey("effectStartTime")) {
      Object obj = map.get("effectStartTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEffectStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEffectStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEffectStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEffectStartTime(null);
      }
    }
    if(map.containsKey("receiptSignDate")) {
      Object obj = map.get("receiptSignDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiptSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReceiptSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReceiptSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiptSignDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCycle")) {
      Object obj = map.get("chargeCycle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeRequirement")) {
      Object obj = map.get("chargeRequirement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeRequirement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeDimension")) {
      Object obj = map.get("chargeDimension");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeDimension((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeUnit")) {
      Object obj = map.get("chargeUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("containsRetentionMoney")) {
      Object obj = map.get("containsRetentionMoney");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContainsRetentionMoney((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeItem")) {
      Object obj = map.get("chargeItem");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uintPrice")) {
      Object obj = map.get("uintPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUintPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUintPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUintPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUintPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUintPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    return entity;
  }
}
