package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 付款条件
 * </p>
 *
 * @author ultraman
 * @since 2021-09-25
 */
public enum PaymentRequirement {

    _0("0", "合同签定"),
    _1("1", "蓝图确认"),
    _3("3", "上线/验收"),
    _2("2", "UAT测试通过");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PaymentRequirement(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PaymentRequirement fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "3":
                return _3;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
