package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 成本归属
 * </p>
 *
 * @author ultraman
 * @since 2021-09-27
 */
public enum CostBelong {

    PD("PD", "产品成本"),
    RD("RD", "研发成本"),
    SA("SA", "销售成本"),
    PS("PS", "售前成本"),
    SL("SL", "解决方案"),
    DL("DL", "交付成本"),
    BU("BU", "BU成本");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CostBelong(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CostBelong fromCode(String code){
        switch(code) {
            case "PD":
                return PD;
            case "RD":
                return RD;
            case "SA":
                return SA;
            case "PS":
                return PS;
            case "SL":
                return SL;
            case "DL":
                return DL;
            case "BU":
                return BU;
            default:
                return null;
        }
    }
}
