package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 产品功能描述
 * </p>
 *
 * @author ultraman
 * @since 2021-09-27
 */
public enum ProductFuctionDesc {

    _0("0", "无"),
    _1("1", "直连"),
    _2("2", "抽取"),
    _3("3", "验真"),
    _4("4", "认证"),
    _5("5", "识别"),
    _6("6", "直连+认证");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProductFuctionDesc(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProductFuctionDesc fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
