package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-09-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Income implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("contractNo")
  private String contractNo;

  @TableField("projectName")
  private String projectName;

  @TableField("statementNo")
  private String statementNo;

  @TableField("useCompanyName")
  private String useCompanyName;

  @TableField("useCompanytaxNo")
  private String useCompanytaxNo;

  private String product;

  @TableField("modelNo")
  private String modelNo;

  private String property;

  private BigDecimal unit;

  private BigDecimal ratio;

  private Long number;

  @TableField("chargeUnit")
  private String chargeUnit;

  @TableField("chargeType")
  private String chargeType;

  @TableField("receiptDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiptDate;

  @TableField("startChargeDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startChargeDate;

  @TableField("endChargeDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endChargeDate;

  @TableField("useMonth")
  private Long useMonth;

  @TableField("useYear")
  private Long useYear;

  @TableField("curIncome")
  private BigDecimal curIncome;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("projectName", projectName);
      map.put("statementNo", statementNo);
      map.put("useCompanyName", useCompanyName);
      map.put("useCompanytaxNo", useCompanytaxNo);
      map.put("product", product);
      map.put("modelNo", modelNo);
      map.put("property", property);
      map.put("unit", unit);
      map.put("ratio", ratio);
      map.put("number", number);
      map.put("chargeUnit", chargeUnit);
      map.put("chargeType", chargeType);
      map.put("receiptDate", BocpGenUtils.toTimestamp(receiptDate));
      map.put("startChargeDate", BocpGenUtils.toTimestamp(startChargeDate));
      map.put("endChargeDate", BocpGenUtils.toTimestamp(endChargeDate));
      map.put("useMonth", useMonth);
      map.put("useYear", useYear);
      map.put("curIncome", curIncome);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static Income fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Income entity = new Income();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementNo")) {
      Object obj = map.get("statementNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useCompanyName")) {
      Object obj = map.get("useCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useCompanytaxNo")) {
      Object obj = map.get("useCompanytaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUseCompanytaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product")) {
      Object obj = map.get("product");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProduct((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("modelNo")) {
      Object obj = map.get("modelNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setModelNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("property")) {
      Object obj = map.get("property");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProperty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ratio")) {
      Object obj = map.get("ratio");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRatio((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRatio(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRatio(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRatio(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRatio(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("number")) {
      Object obj = map.get("number");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setNumber((Long)obj);
        } else if(obj instanceof String) {
          entity.setNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setNumber(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("chargeUnit")) {
      Object obj = map.get("chargeUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptDate")) {
      Object obj = map.get("receiptDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiptDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReceiptDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReceiptDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiptDate(null);
      }
    }
    if(map.containsKey("startChargeDate")) {
      Object obj = map.get("startChargeDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartChargeDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartChargeDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartChargeDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartChargeDate(null);
      }
    }
    if(map.containsKey("endChargeDate")) {
      Object obj = map.get("endChargeDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndChargeDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndChargeDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndChargeDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndChargeDate(null);
      }
    }
    if(map.containsKey("useMonth")) {
      Object obj = map.get("useMonth");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUseMonth((Long)obj);
        } else if(obj instanceof String) {
          entity.setUseMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUseMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("useYear")) {
      Object obj = map.get("useYear");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUseYear((Long)obj);
        } else if(obj instanceof String) {
          entity.setUseYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUseYear(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("curIncome")) {
      Object obj = map.get("curIncome");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
