package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 成本表
 * </p>
 *
 * @author ultraman
 * @since 2021-12-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Costing implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 成本编码
   */
  private String chargeCode;

  /**
   * 产品阶段
   */
  private String productPhase;

  /**
   * 成本归属
   */
  private String chargeBelong;

  /**
   * 成本类型
   */
  private String chargeType;

  /**
   * 数据来源
   */
  private String dataSource;

  /**
   * 成本金额
   */
  private BigDecimal chargeMoney;

  /**
   * 部门名称
   */
  private String departmentName;

  /**
   * 部门编码
   */
  private String departmentCode;

  /**
   * 服务编码
   */
  private String serviceCode;

  /**
   * 服务名称
   */
  private String serviceName;

  /**
   * 提交状态
   */
  private String submitStatus;

  /**
   * 发生时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime occurrenceTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("charge_code", chargeCode);
      map.put("product_phase", productPhase);
      map.put("charge_belong", chargeBelong);
      map.put("charge_type", chargeType);
      map.put("data_source", dataSource);
      map.put("charge_money", chargeMoney);
      map.put("department_name", departmentName);
      map.put("department_code", departmentCode);
      map.put("service_code", serviceCode);
      map.put("service_name", serviceName);
      map.put("submit_status", submitStatus);
      map.put("occurrence_time", BocpGenUtils.toTimestamp(occurrenceTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static Costing fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Costing entity = new Costing();
    if(map.containsKey("charge_code")) {
      Object obj = map.get("charge_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_phase")) {
      Object obj = map.get("product_phase");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductPhase((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_belong")) {
      Object obj = map.get("charge_belong");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeBelong((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_type")) {
      Object obj = map.get("charge_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_source")) {
      Object obj = map.get("data_source");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_money")) {
      Object obj = map.get("charge_money");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChargeMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChargeMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChargeMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setChargeMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChargeMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("department_name")) {
      Object obj = map.get("department_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("department_code")) {
      Object obj = map.get("department_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("service_code")) {
      Object obj = map.get("service_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setServiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("service_name")) {
      Object obj = map.get("service_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setServiceName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submit_status")) {
      Object obj = map.get("submit_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("occurrence_time")) {
      Object obj = map.get("occurrence_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOccurrenceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOccurrenceTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOccurrenceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOccurrenceTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
