package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * chargeCode类型
 * </p>
 *
 * @author ultraman
 * @since 2021-12-23
 */
public enum ChargeCodeTypeEnum {

    SA("SA", "客户"),
    PS("PS", "机会"),
    DL("DL", "项目"),
    CSM("CSM", "客户成功"),
    DC("DC", "数据增值"),
    BU("BU", "BU"),
    PH("PH", "总裁办"),
    PTO("PTO", "交付"),
    LG("LG", "生态业务筹备组"),
    MG("MG", "财务部"),
    CM("CM", "综合管理"),
    SN("SN", "光是"),
    HLD("HLD", "休假"),
    HUM("HUM", "人事部"),
    IDLE("IDLE", "空闲"),
    PTM("PTM", "交付管理"),
    CMG("CMG", "客户服务部"),
    DVP("DVP", "运维"),
    PRD("PRD", "产品"),
    PW("PW", "商联"),
    DEV("DEV", "研发"),
    SLP("SLP", "解决方案"),
    SMB("SMB", "小B运营"),
    STD("STD", "战略运营中心"),
    BS("BS", "售前"),
    SS("SS", "销售"),
    TR("TR", "培训");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeCodeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeTypeEnum fromCode(String code){
        switch(code) {
            case "SA":
                return SA;
            case "PS":
                return PS;
            case "DL":
                return DL;
            case "CSM":
                return CSM;
            case "DC":
                return DC;
            case "BU":
                return BU;
            case "PH":
                return PH;
            case "PTO":
                return PTO;
            case "LG":
                return LG;
            case "MG":
                return MG;
            case "CM":
                return CM;
            case "SN":
                return SN;
            case "HLD":
                return HLD;
            case "HUM":
                return HUM;
            case "IDLE":
                return IDLE;
            case "PTM":
                return PTM;
            case "CMG":
                return CMG;
            case "DVP":
                return DVP;
            case "PRD":
                return PRD;
            case "PW":
                return PW;
            case "DEV":
                return DEV;
            case "SLP":
                return SLP;
            case "SMB":
                return SMB;
            case "STD":
                return STD;
            case "BS":
                return BS;
            case "SS":
                return SS;
            case "TR":
                return TR;
            default:
                return null;
        }
    }
}
