package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 合同主信息
 * </p>
 *
 * @author ultraman
 * @since 2021-12-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Contract implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 项目编号
   */
  @TableField("projectNo")
  private String projectNo;

  /**
   * 项目名称
   */
  @TableField("projectName")
  private String projectName;

  /**
   * 签约团队
   */
  @TableField("signTeam")
  private String signTeam;

  /**
   * 签署方名称
   */
  @TableField("signatoryName")
  private String signatoryName;

  /**
   * 合同有效期约定
   */
  @TableField("periodPromise")
  private String periodPromise;

  /**
   * 账期
   */
  @TableField("paymentPeriod")
  private Long paymentPeriod;

  /**
   * 账期性质
   */
  @TableField("paymentPeriodType")
  private String paymentPeriodType;

  /**
   * 合同签订日期
   */
  @TableField("signDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signDate;

  /**
   * 合同生效日期
   */
  @TableField("effectStartTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime effectStartTime;

  /**
   * 验收时间
   */
  @TableField("receiptSignDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiptSignDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 是否有质保金
   */
  @TableField("containsRetentionMoney")
  private String containsRetentionMoney;

  /**
   * 项目ChargeCode
   */
  @TableField("chargeCode")
  private String chargeCode;

  /**
   * 合同到期日期
   */
  @TableField("contractExpiryDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime contractExpiryDate;

  /**
   * 合同类型
   */
  @TableField("contractType")
  private String contractType;

  /**
   * 合同总金额(含税)
   */
  @TableField("contractTotalMoney")
  private BigDecimal contractTotalMoney;

  /**
   * 租户名称
   */
  @TableField("tenantName")
  private String tenantName;

  /**
   * 经营单元
   */
  @TableField("businessUnit")
  private String businessUnit;

  /**
   * 负责人
   */
  @TableField("principalPerson")
  private String principalPerson;

  /**
   * 租户id
   */
  @TableField("tenantGroupId")
  private Long tenantGroupId;

  /**
   * 合同id
   */
  @TableField("chargeContractId")
  private String chargeContractId;

  /**
   * 大区
   */
  private String region;

  /**
   * 大区id
   */
  @TableField("regionId")
  private String regionId;

  /**
   * 客户编号
   */
  @TableField("saChargeCode")
  private String saChargeCode;

  /**
   * 客户名称
   */
  @TableField("saChargeCodeName")
  private String saChargeCodeName;

  /**
   * 父合同编号
   */
  @TableField("parentContractNo")
  private String parentContractNo;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("projectNo", projectNo);
      map.put("projectName", projectName);
      map.put("signTeam", signTeam);
      map.put("signatoryName", signatoryName);
      map.put("periodPromise", periodPromise);
      map.put("paymentPeriod", paymentPeriod);
      map.put("paymentPeriodType", paymentPeriodType);
      map.put("signDate", BocpGenUtils.toTimestamp(signDate));
      map.put("effectStartTime", BocpGenUtils.toTimestamp(effectStartTime));
      map.put("receiptSignDate", BocpGenUtils.toTimestamp(receiptSignDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("containsRetentionMoney", containsRetentionMoney);
      map.put("chargeCode", chargeCode);
      map.put("contractExpiryDate", BocpGenUtils.toTimestamp(contractExpiryDate));
      map.put("contractType", contractType);
      map.put("contractTotalMoney", contractTotalMoney);
      map.put("tenantName", tenantName);
      map.put("businessUnit", businessUnit);
      map.put("principalPerson", principalPerson);
      map.put("tenantGroupId", tenantGroupId);
      map.put("chargeContractId", chargeContractId);
      map.put("region", region);
      map.put("regionId", regionId);
      map.put("saChargeCode", saChargeCode);
      map.put("saChargeCodeName", saChargeCodeName);
      map.put("parentContractNo", parentContractNo);
      return map;
  }

  public static Contract fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Contract entity = new Contract();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signTeam")) {
      Object obj = map.get("signTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signatoryName")) {
      Object obj = map.get("signatoryName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignatoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("periodPromise")) {
      Object obj = map.get("periodPromise");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPeriodPromise((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPeriod")) {
      Object obj = map.get("paymentPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentPeriod((Long)obj);
        } else if(obj instanceof String) {
          entity.setPaymentPeriod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPaymentPeriod(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paymentPeriodType")) {
      Object obj = map.get("paymentPeriodType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentPeriodType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signDate")) {
      Object obj = map.get("signDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignDate(null);
      }
    }
    if(map.containsKey("effectStartTime")) {
      Object obj = map.get("effectStartTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEffectStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEffectStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEffectStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEffectStartTime(null);
      }
    }
    if(map.containsKey("receiptSignDate")) {
      Object obj = map.get("receiptSignDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiptSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReceiptSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReceiptSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiptSignDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("containsRetentionMoney")) {
      Object obj = map.get("containsRetentionMoney");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContainsRetentionMoney((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractExpiryDate")) {
      Object obj = map.get("contractExpiryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setContractExpiryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setContractExpiryDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setContractExpiryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setContractExpiryDate(null);
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractTotalMoney")) {
      Object obj = map.get("contractTotalMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setContractTotalMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setContractTotalMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setContractTotalMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setContractTotalMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setContractTotalMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessUnit")) {
      Object obj = map.get("businessUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("principalPerson")) {
      Object obj = map.get("principalPerson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrincipalPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantGroupId")) {
      Object obj = map.get("tenantGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantGroupId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("chargeContractId")) {
      Object obj = map.get("chargeContractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionId")) {
      Object obj = map.get("regionId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saChargeCode")) {
      Object obj = map.get("saChargeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saChargeCodeName")) {
      Object obj = map.get("saChargeCodeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaChargeCodeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parentContractNo")) {
      Object obj = map.get("parentContractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setParentContractNo((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
