package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 订单
 * </p>
 *
 * @author ultraman
 * @since 2021-12-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Order implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 付费方式
   */
  @TableField("chargeType")
  private String chargeType;

  /**
   * 付款条件
   */
  @TableField("paymentRequirement")
  private String paymentRequirement;

  /**
   * 订单结算金额(含税)
   */
  @TableField("totalAmountWithTax")
  private String totalAmountWithTax;

  /**
   * 折抵/优惠金额应付金额（含税）
   */
  @TableField("discountAmount")
  private String discountAmount;

  /**
   * 应付金额（含税）
   */
  @TableField("payableAmount")
  private String payableAmount;

  /**
   * 实付金额
   */
  @TableField("actualPaymentAmount")
  private String actualPaymentAmount;

  /**
   * 订单生成日期
   */
  @TableField("generateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime generateDate;

  /**
   * 对账状态
   */
  @TableField("reconciliationStatus")
  private String reconciliationStatus;

  /**
   * 支付状态
   */
  @TableField("paymentStatus")
  private String paymentStatus;

  /**
   * 发票开具状态
   */
  @TableField("invoiceStatus")
  private String invoiceStatus;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 订单类型
   */
  @TableField("orderType")
  private String orderType;

  /**
   * 是否验收
   */
  private Boolean validated;

  /**
   * 结算周期开始时间
   */
  @TableField("chargeStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeStartDate;

  /**
   * 结算周期结束时间
   */
  @TableField("chargeEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeEndDate;

  /**
   * 税号数量
   */
  @TableField("taxQuantity")
  private BigDecimal taxQuantity;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 单价
   */
  @TableField("unitPriceWithoutTax")
  private BigDecimal unitPriceWithoutTax;

  /**
   * 计价单位
   */
  @TableField("chargeUnit")
  private String chargeUnit;

  /**
   * 产品编号
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 优惠金额(不含税)
   */
  @TableField("discountAmountWithoutTax")
  private String discountAmountWithoutTax;

  /**
   * 项目名称
   */
  @TableField("projectName")
  private String projectName;

  /**
   * 订单状态
   */
  @TableField("orderStatus")
  private String orderStatus;

  /**
   * 是否质保金
   */
  @TableField("retentionMoney")
  private String retentionMoney;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("orderNo", orderNo);
      map.put("contractNo", contractNo);
      map.put("productName", productName);
      map.put("chargeType", chargeType);
      map.put("paymentRequirement", paymentRequirement);
      map.put("totalAmountWithTax", totalAmountWithTax);
      map.put("discountAmount", discountAmount);
      map.put("payableAmount", payableAmount);
      map.put("actualPaymentAmount", actualPaymentAmount);
      map.put("generateDate", BocpGenUtils.toTimestamp(generateDate));
      map.put("reconciliationStatus", reconciliationStatus);
      map.put("paymentStatus", paymentStatus);
      map.put("invoiceStatus", invoiceStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("orderType", orderType);
      map.put("validated", validated);
      map.put("chargeStartDate", BocpGenUtils.toTimestamp(chargeStartDate));
      map.put("chargeEndDate", BocpGenUtils.toTimestamp(chargeEndDate));
      map.put("taxQuantity", taxQuantity);
      map.put("taxRate", taxRate);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("chargeUnit", chargeUnit);
      map.put("productCode", productCode);
      map.put("discountAmountWithoutTax", discountAmountWithoutTax);
      map.put("projectName", projectName);
      map.put("orderStatus", orderStatus);
      map.put("retentionMoney", retentionMoney);
      return map;
  }

  public static Order fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Order entity = new Order();
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentRequirement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmountWithTax")) {
      Object obj = map.get("totalAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountAmount")) {
      Object obj = map.get("discountAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscountAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payableAmount")) {
      Object obj = map.get("payableAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayableAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("actualPaymentAmount")) {
      Object obj = map.get("actualPaymentAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setActualPaymentAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generateDate")) {
      Object obj = map.get("generateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGenerateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGenerateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setGenerateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGenerateDate(null);
      }
    }
    if(map.containsKey("reconciliationStatus")) {
      Object obj = map.get("reconciliationStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReconciliationStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("validated")) {
      Object obj = map.get("validated");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setValidated((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setValidated(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeEndDate(null);
      }
    }
    if(map.containsKey("taxQuantity")) {
      Object obj = map.get("taxQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("chargeUnit")) {
      Object obj = map.get("chargeUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountAmountWithoutTax")) {
      Object obj = map.get("discountAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscountAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retentionMoney")) {
      Object obj = map.get("retentionMoney");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetentionMoney((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
