package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 同步类型
 * </p>
 *
 * @author ultraman
 * @since 2022-01-17
 */
public enum SynchronizeType {

    INSERT("insert", "新增"),
    UPDATE("update", "同步");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SynchronizeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SynchronizeType fromCode(String code){
        switch(code) {
            case "insert":
                return INSERT;
            case "update":
                return UPDATE;
            default:
                return null;
        }
    }
}
