package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费类型
 * </p>
 *
 * @author ultraman
 * @since 2022-01-25
 */
public enum ChargeTypeEnum {

    _1("1", "按照租户打包价"),
    _2("2", "按照税号打包价"),
    _3("3", "单价"),
    _4("4", "阶梯价"),
    _5("5", "打包价按业务维度"),
    _6("6", "租户打包价按业务维度"),
    _7("7", "按业务维度阶梯");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeTypeEnum fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
