package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 合同主信息
 * </p>
 *
 * @author ultraman
 * @since 2022-01-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Contract implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 项目编号
   */
  @TableField("projectNo")
  private String projectNo;

  /**
   * 项目名称
   */
  @TableField("projectName")
  private String projectName;

  /**
   * 合同有效期约定
   */
  @TableField("periodPromise")
  private String periodPromise;

  /**
   * 账期
   */
  @TableField("paymentPeriod")
  private Long paymentPeriod;

  /**
   * 账期性质
   */
  @TableField("paymentPeriodType")
  private String paymentPeriodType;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 是否包含保证金
   */
  @TableField("containsRetentionMoney")
  private Boolean containsRetentionMoney;

  /**
   * 项目ChargeCode
   */
  @TableField("chargeCode")
  private String chargeCode;

  /**
   * 合同类型
   */
  @TableField("contractType")
  private String contractType;

  /**
   * 合同总金额(含税)
   */
  @TableField("contractTotalMoney")
  private BigDecimal contractTotalMoney;

  /**
   * 经营单元
   */
  @TableField("businessUnit")
  private String businessUnit;

  /**
   * 负责人
   */
  @TableField("principalPerson")
  private String principalPerson;

  /**
   * 合同id
   */
  @TableField("chargeContractId")
  private String chargeContractId;

  /**
   * 客户编号
   */
  @TableField("saChargeCode")
  private String saChargeCode;

  /**
   * 客户名称
   */
  @TableField("saChargeCodeName")
  private String saChargeCodeName;

  /**
   * 合同总金额(含税)
   */
  @TableField("totalAmountWithTax")
  private String totalAmountWithTax;

  /**
   * 父合同编号
   */
  @TableField("relatedContractNo")
  private String relatedContractNo;

  /**
   * 签约团队编号
   */
  @TableField("signTeamCode")
  private String signTeamCode;

  /**
   * 签约团队名称
   */
  @TableField("signTeamName")
  private String signTeamName;

  /**
   * 客户签约方税号
   */
  @TableField("customerSignatoryTaxNos")
  private String customerSignatoryTaxNos;

  /**
   * 签署方名称
   */
  @TableField("customerSignatoryName")
  private String customerSignatoryName;

  /**
   * 差旅费承担方
   */
  @TableField("expenseBearer")
  private String expenseBearer;

  /**
   * 经营单元部门编号
   */
  @TableField("businessUnitDeptCode")
  private String businessUnitDeptCode;

  /**
   * 客户
   */
  private String customer;

  /**
   * 负责人（kam）工号
   */
  @TableField("kamCode")
  private String kamCode;

  /**
   * 负责人（kam）名字
   */
  @TableField("kamName")
  private String kamName;

  /**
   * 大区编号
   */
  @TableField("regionCode")
  private String regionCode;

  /**
   * 大区名称
   */
  @TableField("regionName")
  private String regionName;

  /**
   * 我司签约方名称
   */
  @TableField("ourSignatoryName")
  private String ourSignatoryName;

  /**
   * 我司签约方税号
   */
  @TableField("ourSignatoryTaxNo")
  private String ourSignatoryTaxNo;

  /**
   * 结算周期
   */
  @TableField("chargeCycle")
  private String chargeCycle;

  /**
   * 合同附件
   */
  @TableField("attachmentUrl")
  private String attachmentUrl;

  /**
   * 合同签订日期
   */
  @TableField("signDateStr")
  private String signDateStr;

  /**
   * 合同到期日期
   */
  @TableField("expiryDateStr")
  private String expiryDateStr;

  /**
   * 验收报告签署日期时间
   */
  @TableField("receiptSignDateStr")
  private String receiptSignDateStr;

  /**
   * 生效日期
   */
  @TableField("effectiveDateStr")
  private String effectiveDateStr;

  /**
   * 合同状态
   */
  @TableField("contractStatus")
  private String contractStatus;

  /**
   * 合同版本
   */
  @TableField("contractVersion")
  private Long contractVersion;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("projectNo", projectNo);
      map.put("projectName", projectName);
      map.put("periodPromise", periodPromise);
      map.put("paymentPeriod", paymentPeriod);
      map.put("paymentPeriodType", paymentPeriodType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("containsRetentionMoney", containsRetentionMoney);
      map.put("chargeCode", chargeCode);
      map.put("contractType", contractType);
      map.put("contractTotalMoney", contractTotalMoney);
      map.put("businessUnit", businessUnit);
      map.put("principalPerson", principalPerson);
      map.put("chargeContractId", chargeContractId);
      map.put("saChargeCode", saChargeCode);
      map.put("saChargeCodeName", saChargeCodeName);
      map.put("totalAmountWithTax", totalAmountWithTax);
      map.put("relatedContractNo", relatedContractNo);
      map.put("signTeamCode", signTeamCode);
      map.put("signTeamName", signTeamName);
      map.put("customerSignatoryTaxNos", customerSignatoryTaxNos);
      map.put("customerSignatoryName", customerSignatoryName);
      map.put("expenseBearer", expenseBearer);
      map.put("businessUnitDeptCode", businessUnitDeptCode);
      map.put("customer", customer);
      map.put("kamCode", kamCode);
      map.put("kamName", kamName);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("ourSignatoryName", ourSignatoryName);
      map.put("ourSignatoryTaxNo", ourSignatoryTaxNo);
      map.put("chargeCycle", chargeCycle);
      map.put("attachmentUrl", attachmentUrl);
      map.put("signDateStr", signDateStr);
      map.put("expiryDateStr", expiryDateStr);
      map.put("receiptSignDateStr", receiptSignDateStr);
      map.put("effectiveDateStr", effectiveDateStr);
      map.put("contractStatus", contractStatus);
      map.put("contractVersion", contractVersion);
      return map;
  }

  public static Contract fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Contract entity = new Contract();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("periodPromise")) {
      Object obj = map.get("periodPromise");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPeriodPromise((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPeriod")) {
      Object obj = map.get("paymentPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentPeriod((Long)obj);
        } else if(obj instanceof String) {
          entity.setPaymentPeriod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentPeriod(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paymentPeriodType")) {
      Object obj = map.get("paymentPeriodType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentPeriodType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("containsRetentionMoney")) {
      Object obj = map.get("containsRetentionMoney");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setContainsRetentionMoney((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setContainsRetentionMoney(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractTotalMoney")) {
      Object obj = map.get("contractTotalMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setContractTotalMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setContractTotalMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setContractTotalMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setContractTotalMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setContractTotalMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("businessUnit")) {
      Object obj = map.get("businessUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("principalPerson")) {
      Object obj = map.get("principalPerson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrincipalPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeContractId")) {
      Object obj = map.get("chargeContractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saChargeCode")) {
      Object obj = map.get("saChargeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saChargeCodeName")) {
      Object obj = map.get("saChargeCodeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaChargeCodeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmountWithTax")) {
      Object obj = map.get("totalAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relatedContractNo")) {
      Object obj = map.get("relatedContractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelatedContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signTeamCode")) {
      Object obj = map.get("signTeamCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignTeamCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signTeamName")) {
      Object obj = map.get("signTeamName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignTeamName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerSignatoryTaxNos")) {
      Object obj = map.get("customerSignatoryTaxNos");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerSignatoryTaxNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerSignatoryName")) {
      Object obj = map.get("customerSignatoryName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerSignatoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseBearer")) {
      Object obj = map.get("expenseBearer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpenseBearer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessUnitDeptCode")) {
      Object obj = map.get("businessUnitDeptCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessUnitDeptCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kamCode")) {
      Object obj = map.get("kamCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKamCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kamName")) {
      Object obj = map.get("kamName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKamName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ourSignatoryName")) {
      Object obj = map.get("ourSignatoryName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOurSignatoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ourSignatoryTaxNo")) {
      Object obj = map.get("ourSignatoryTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOurSignatoryTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCycle")) {
      Object obj = map.get("chargeCycle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attachmentUrl")) {
      Object obj = map.get("attachmentUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAttachmentUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signDateStr")) {
      Object obj = map.get("signDateStr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignDateStr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expiryDateStr")) {
      Object obj = map.get("expiryDateStr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpiryDateStr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptSignDateStr")) {
      Object obj = map.get("receiptSignDateStr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiptSignDateStr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effectiveDateStr")) {
      Object obj = map.get("effectiveDateStr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEffectiveDateStr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractStatus")) {
      Object obj = map.get("contractStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractVersion")) {
      Object obj = map.get("contractVersion");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setContractVersion((Long)obj);
        } else if(obj instanceof String) {
          entity.setContractVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setContractVersion(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("periodPromise")) {
      Object obj = map.get("periodPromise");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPeriodPromise((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentPeriod")) {
      Object obj = map.get("paymentPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPaymentPeriod((Long)obj);
        } else if(obj instanceof String) {
          this.setPaymentPeriod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaymentPeriod(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("paymentPeriodType")) {
      Object obj = map.get("paymentPeriodType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentPeriodType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("containsRetentionMoney")) {
      Object obj = map.get("containsRetentionMoney");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setContainsRetentionMoney((Boolean)obj);
        } else if(obj instanceof String) {
          this.setContainsRetentionMoney(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractTotalMoney")) {
      Object obj = map.get("contractTotalMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setContractTotalMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setContractTotalMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setContractTotalMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setContractTotalMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setContractTotalMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("businessUnit")) {
      Object obj = map.get("businessUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("principalPerson")) {
      Object obj = map.get("principalPerson");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrincipalPerson((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeContractId")) {
      Object obj = map.get("chargeContractId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeContractId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("saChargeCode")) {
      Object obj = map.get("saChargeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaChargeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("saChargeCodeName")) {
      Object obj = map.get("saChargeCodeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaChargeCodeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("totalAmountWithTax")) {
      Object obj = map.get("totalAmountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTotalAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("relatedContractNo")) {
      Object obj = map.get("relatedContractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRelatedContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("signTeamCode")) {
      Object obj = map.get("signTeamCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSignTeamCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("signTeamName")) {
      Object obj = map.get("signTeamName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSignTeamName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerSignatoryTaxNos")) {
      Object obj = map.get("customerSignatoryTaxNos");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerSignatoryTaxNos((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerSignatoryName")) {
      Object obj = map.get("customerSignatoryName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerSignatoryName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expenseBearer")) {
      Object obj = map.get("expenseBearer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseBearer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessUnitDeptCode")) {
      Object obj = map.get("businessUnitDeptCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessUnitDeptCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kamCode")) {
      Object obj = map.get("kamCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKamCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kamName")) {
      Object obj = map.get("kamName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKamName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ourSignatoryName")) {
      Object obj = map.get("ourSignatoryName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOurSignatoryName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ourSignatoryTaxNo")) {
      Object obj = map.get("ourSignatoryTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOurSignatoryTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeCycle")) {
      Object obj = map.get("chargeCycle");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeCycle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attachmentUrl")) {
      Object obj = map.get("attachmentUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttachmentUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("signDateStr")) {
      Object obj = map.get("signDateStr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSignDateStr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expiryDateStr")) {
      Object obj = map.get("expiryDateStr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpiryDateStr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiptSignDateStr")) {
      Object obj = map.get("receiptSignDateStr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiptSignDateStr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("effectiveDateStr")) {
      Object obj = map.get("effectiveDateStr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEffectiveDateStr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractStatus")) {
      Object obj = map.get("contractStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractVersion")) {
      Object obj = map.get("contractVersion");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setContractVersion((Long)obj);
        } else if(obj instanceof String) {
          this.setContractVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setContractVersion(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
  }
}
