package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费时间生效标识
 * </p>
 *
 * @author ultraman
 * @since 2022-02-22
 */
public enum ChargeVaildLogo {

    SIGN("sign", "签订"),
    VALIDATION("validation", "验收"),
    USING_TIME("usingTime", "使用");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeVaildLogo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeVaildLogo fromCode(String code){
        switch(code) {
            case "sign":
                return SIGN;
            case "validation":
                return VALIDATION;
            case "usingTime":
                return USING_TIME;
            default:
                return null;
        }
    }
}
