package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 多维度关系明细类型
 * </p>
 *
 * @author ultraman
 * @since 2022-02-23
 */
public enum MultiRelationDetailEnum {

    NORMAL("normal", "正常"),
    COMPENSATE("compensate", "补偿");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MultiRelationDetailEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MultiRelationDetailEnum fromCode(String code){
        switch(code) {
            case "normal":
                return NORMAL;
            case "compensate":
                return COMPENSATE;
            default:
                return null;
        }
    }
}
