package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 服务成本主信息
 * </p>
 *
 * @author ultraman
 * @since 2022-02-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ServiceCost implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 服务类型
   */
  private String serviceType;

  /**
   * 服务编码
   */
  private String serviceCode;

  /**
   * 服务名称
   */
  private String serviceName;

  /**
   * 统计时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime occrencyTime;

  /**
   * 分摊流水编号
   */
  private String divideCode;

  /**
   * 当前状态
   */
  private String currencyStatus;

  /**
   * 累计成本
   */
  private BigDecimal cumulativeCost;

  /**
   * 当期成本
   */
  private BigDecimal currentCost;

  /**
   * 累计用量
   */
  private BigDecimal cumulativeOutput;

  /**
   * 当期用量
   */
  private BigDecimal currentOutput;

  /**
   * 会计年度
   */
  private Long accountingYear;

  /**
   * 会计期间
   */
  private Long accountingMonth;

  /**
   * 单价
   */
  private BigDecimal unitPrice;

  /**
   * 成本编码
   */
  private String srvCode;

  /**
   * 成本名称
   */
  private String srvName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("service_type", serviceType);
      map.put("service_code", serviceCode);
      map.put("service_name", serviceName);
      map.put("occrency_time", BocpGenUtils.toTimestamp(occrencyTime));
      map.put("divide_code", divideCode);
      map.put("currency_status", currencyStatus);
      map.put("cumulative_cost", cumulativeCost);
      map.put("current_cost", currentCost);
      map.put("cumulative_output", cumulativeOutput);
      map.put("current_output", currentOutput);
      map.put("accounting_year", accountingYear);
      map.put("accounting_month", accountingMonth);
      map.put("unit_price", unitPrice);
      map.put("srv_code", srvCode);
      map.put("srv_name", srvName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static ServiceCost fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ServiceCost entity = new ServiceCost();
    if(map.containsKey("service_type")) {
      Object obj = map.get("service_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setServiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("service_code")) {
      Object obj = map.get("service_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setServiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("service_name")) {
      Object obj = map.get("service_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setServiceName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("occrency_time")) {
      Object obj = map.get("occrency_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOccrencyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOccrencyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOccrencyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOccrencyTime(null);
      }
    }
    if(map.containsKey("divide_code")) {
      Object obj = map.get("divide_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDivideCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency_status")) {
      Object obj = map.get("currency_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrencyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cumulative_cost")) {
      Object obj = map.get("cumulative_cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCumulativeCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCumulativeCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCumulativeCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCumulativeCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCumulativeCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("current_cost")) {
      Object obj = map.get("current_cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cumulative_output")) {
      Object obj = map.get("cumulative_output");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCumulativeOutput((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCumulativeOutput(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCumulativeOutput(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCumulativeOutput(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCumulativeOutput(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("current_output")) {
      Object obj = map.get("current_output");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentOutput((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentOutput(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentOutput(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentOutput(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentOutput(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("accounting_year")) {
      Object obj = map.get("accounting_year");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingYear((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountingYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAccountingYear(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("accounting_month")) {
      Object obj = map.get("accounting_month");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingMonth((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountingMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAccountingMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("srv_code")) {
      Object obj = map.get("srv_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSrvCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("srv_name")) {
      Object obj = map.get("srv_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSrvName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
