package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费类型
 * </p>
 *
 * @author ultraman
 * @since 2022-02-24
 */
public enum Dimension {

    SINGLE_PRICE("singlePrice", "单价"),
    NO_LIMITATION("noLimitation", "打包价(税号)"),
    LIMITATION("limitation", "打包价(限量)");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Dimension(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Dimension fromCode(String code){
        switch(code) {
            case "singlePrice":
                return SINGLE_PRICE;
            case "noLimitation":
                return NO_LIMITATION;
            case "limitation":
                return LIMITATION;
            default:
                return null;
        }
    }
}
