package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 产品型号
 * </p>
 *
 * @author ultraman
 * @since 2022-03-11
 */
public enum ProductType {

    _0("0", "无"),
    _1("1", "M1200"),
    _2("2", "S825"),
    _3("3", "次年"),
    _4("4", "首年"),
    _5("5", "60口"),
    _6("6", "90口"),
    _7("7", "黑色碳粉盒"),
    _8("8", "红色碳粉盒"),
    _9("9", "黑色硒鼓"),
    _10("10", "红色硒鼓"),
    _11("11", "BO378"),
    _12("12", "jmr139"),
    _13("13", "P355-K20"),
    _14("14", "D80-3"),
    _15("15", "UEX-20"),
    _16("16", "PYT241-19"),
    _17("17", "UEX-60A"),
    _18("18", "硒鼓耗材"),
    _19("19", "一般计税"),
    _20("20", "混合计税"),
    _21("21", "简易计税"),
    _22("22", "打印机针头"),
    _23("23", "L7350"),
    _24("24", "打印机塑料条"),
    _25("25", "电源"),
    _26("26", "分页轮"),
    _27("27", "色带"),
    _28("28", "DF241-10"),
    _29("29", "粉盒硒鼓"),
    _30("30", "霍尼韦尔 1900GHD"),
    _31("31", "科密 EW-9200"),
    _32("32", "发票章"),
    _33("33", "搓纸滚轮"),
    _34("34", "齿轮"),
    _35("35", "打印机拖链");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProductType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProductType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "19":
                return _19;
            case "20":
                return _20;
            case "21":
                return _21;
            case "22":
                return _22;
            case "23":
                return _23;
            case "24":
                return _24;
            case "25":
                return _25;
            case "26":
                return _26;
            case "27":
                return _27;
            case "28":
                return _28;
            case "29":
                return _29;
            case "30":
                return _30;
            case "31":
                return _31;
            case "32":
                return _32;
            case "33":
                return _33;
            case "34":
                return _34;
            case "35":
                return _35;
            default:
                return null;
        }
    }
}
