package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 收入表明细
 * </p>
 *
 * @author ultraman
 * @since 2022-03-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class IncomeDetail implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 项目名称
   */
  @TableField("projectName")
  private String projectName;

  /**
   * 对账单编号
   */
  @TableField("statementNo")
  private String statementNo;

  /**
   * 性质
   */
  private String property;

  /**
   * 计价单位
   */
  @TableField("chargeUnit")
  private String chargeUnit;

  /**
   * 开始计费日期
   */
  @TableField("startChargeDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startChargeDate;

  /**
   * 结束计费日期
   */
  @TableField("endChargeDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endChargeDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 使用公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 使用公司税号
   */
  @TableField("companyTax")
  private String companyTax;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 数量
   */
  private BigDecimal amount;

  /**
   * 单价(不含税)
   */
  @TableField("unitPriceWithoutTax")
  private BigDecimal unitPriceWithoutTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 当期收入金额(不含税)
   */
  @TableField("currentIncomeWithoutTax")
  private BigDecimal currentIncomeWithoutTax;

  /**
   * 验收日期
   */
  @TableField("acceptanceDate")
  private String acceptanceDate;

  /**
   * 会计期间
   */
  @TableField("accountingTime")
  private String accountingTime;

  /**
   * 计价方式
   */
  @TableField("chargeMethod")
  private String chargeMethod;

  /**
   * 使用月份
   */
  @TableField("usingMonth")
  private String usingMonth;

  /**
   * 状态
   */
  private String status;

  /**
   * 客户
   */
  private String customer;

  /**
   * 经营单元
   */
  @TableField("businessUnit")
  private String businessUnit;

  /**
   * 负责人
   */
  @TableField("principalPerson")
  private String principalPerson;

  /**
   * 大区
   */
  private String region;

  /**
   * 大区id
   */
  @TableField("regionId")
  private String regionId;

  /**
   * 订单号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 产品code
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 相关订单号
   */
  @TableField("relatedOrderNos")
  private String relatedOrderNos;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("projectName", projectName);
      map.put("statementNo", statementNo);
      map.put("property", property);
      map.put("chargeUnit", chargeUnit);
      map.put("startChargeDate", BocpGenUtils.toTimestamp(startChargeDate));
      map.put("endChargeDate", BocpGenUtils.toTimestamp(endChargeDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("companyName", companyName);
      map.put("companyTax", companyTax);
      map.put("productName", productName);
      map.put("amount", amount);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("taxRate", taxRate);
      map.put("currentIncomeWithoutTax", currentIncomeWithoutTax);
      map.put("acceptanceDate", acceptanceDate);
      map.put("accountingTime", accountingTime);
      map.put("chargeMethod", chargeMethod);
      map.put("usingMonth", usingMonth);
      map.put("status", status);
      map.put("customer", customer);
      map.put("businessUnit", businessUnit);
      map.put("principalPerson", principalPerson);
      map.put("region", region);
      map.put("regionId", regionId);
      map.put("orderNo", orderNo);
      map.put("productCode", productCode);
      map.put("relatedOrderNos", relatedOrderNos);
      return map;
  }

  public static IncomeDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    IncomeDetail entity = new IncomeDetail();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementNo")) {
      Object obj = map.get("statementNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("property")) {
      Object obj = map.get("property");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProperty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeUnit")) {
      Object obj = map.get("chargeUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startChargeDate")) {
      Object obj = map.get("startChargeDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartChargeDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartChargeDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartChargeDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartChargeDate(null);
      }
    }
    if(map.containsKey("endChargeDate")) {
      Object obj = map.get("endChargeDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndChargeDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndChargeDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndChargeDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndChargeDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTax")) {
      Object obj = map.get("companyTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentIncomeWithoutTax")) {
      Object obj = map.get("currentIncomeWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentIncomeWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentIncomeWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentIncomeWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentIncomeWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentIncomeWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("acceptanceDate")) {
      Object obj = map.get("acceptanceDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAcceptanceDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountingTime")) {
      Object obj = map.get("accountingTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountingTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeMethod")) {
      Object obj = map.get("chargeMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("usingMonth")) {
      Object obj = map.get("usingMonth");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUsingMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessUnit")) {
      Object obj = map.get("businessUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("principalPerson")) {
      Object obj = map.get("principalPerson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrincipalPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionId")) {
      Object obj = map.get("regionId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relatedOrderNos")) {
      Object obj = map.get("relatedOrderNos");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelatedOrderNos((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
