package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费类型
 * </p>
 *
 * @author ultraman
 * @since 2022-03-17
 */
public enum BillingType {

    _1("1", "按功能打包价"),
    _2("2", "按税号打包价"),
    _3("3", "按单价"),
    _4("4", "按阶梯价"),
    _5("5", "按阶梯价");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillingType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillingType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
