package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-03-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Bill implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 结算对账主单号
   */
  @TableField("billNo")
  private String billNo;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 产品编号
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 结算单生成日期
   */
  @TableField("generateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime generateDate;

  /**
   * 对账状态
   */
  @TableField("reconciliationStatus")
  private String reconciliationStatus;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 处理状态
   */
  @TableField("handleStatus")
  private String handleStatus;

  /**
   * 结算开始日期
   */
  @TableField("accountintStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountintStartDate;

  /**
   * 结算结束日期
   */
  @TableField("accountintEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountintEndDate;

  /**
   * 结算金额（含税）
   */
  @TableField("billAmountWithTax")
  private BigDecimal billAmountWithTax;

  /**
   * 优惠金额（含税）
   */
  @TableField("discountAmountWithTax")
  private BigDecimal discountAmountWithTax;

  /**
   * 租户代码
   */
  @TableField("bTenantCode")
  private String bTenantCode;

  /**
   * 租户名称
   */
  @TableField("bTenantName")
  private String bTenantName;

  /**
   * 租户Id
   */
  @TableField("bTenantId")
  private Long bTenantId;

  /**
   * 实付金额
   */
  @TableField("paymentAmount")
  private BigDecimal paymentAmount;

  /**
   * 产品税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 税号数量
   */
  @TableField("taxCount")
  private Long taxCount;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billNo", billNo);
      map.put("contractNo", contractNo);
      map.put("productCode", productCode);
      map.put("generateDate", BocpGenUtils.toTimestamp(generateDate));
      map.put("reconciliationStatus", reconciliationStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("handleStatus", handleStatus);
      map.put("accountintStartDate", BocpGenUtils.toTimestamp(accountintStartDate));
      map.put("accountintEndDate", BocpGenUtils.toTimestamp(accountintEndDate));
      map.put("billAmountWithTax", billAmountWithTax);
      map.put("discountAmountWithTax", discountAmountWithTax);
      map.put("bTenantCode", bTenantCode);
      map.put("bTenantName", bTenantName);
      map.put("bTenantId", bTenantId);
      map.put("paymentAmount", paymentAmount);
      map.put("taxRate", taxRate);
      map.put("taxCount", taxCount);
      map.put("productName", productName);
      return map;
  }

  public static Bill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Bill entity = new Bill();
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generateDate")) {
      Object obj = map.get("generateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGenerateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGenerateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setGenerateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGenerateDate(null);
      }
    }
    if(map.containsKey("reconciliationStatus")) {
      Object obj = map.get("reconciliationStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReconciliationStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountintStartDate")) {
      Object obj = map.get("accountintStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountintStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountintStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountintStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountintStartDate(null);
      }
    }
    if(map.containsKey("accountintEndDate")) {
      Object obj = map.get("accountintEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountintEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountintEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountintEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountintEndDate(null);
      }
    }
    if(map.containsKey("billAmountWithTax")) {
      Object obj = map.get("billAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBillAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountAmountWithTax")) {
      Object obj = map.get("discountAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bTenantCode")) {
      Object obj = map.get("bTenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantName")) {
      Object obj = map.get("bTenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantId")) {
      Object obj = map.get("bTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paymentAmount")) {
      Object obj = map.get("paymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxCount")) {
      Object obj = map.get("taxCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setTaxCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTaxCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
