package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-04-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillDetailMonth implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 结算账单号
   */
  @TableField("billCycleId")
  private Long billCycleId;

  /**
   * 合同号
   */
  @TableField("contractCode")
  private String contractCode;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 产品code
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 公司税号
   */
  @TableField("taxNum")
  private String taxNum;

  /**
   * 公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 计费量
   */
  @TableField("usageCount")
  private BigDecimal usageCount;

  /**
   * 使用月份-作废
   */
  @TableField("billMonth")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billMonth;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 使用月份Str
   */
  @TableField("billMonthStr")
  private String billMonthStr;

  /**
   * 公司税号PK
   */
  @TableField("taxNumPk")
  private String taxNumPk;

  /**
   * 租户code
   */
  @TableField("bTenantCode")
  private String bTenantCode;

  /**
   * 租户名称
   */
  @TableField("bTenantName")
  private String bTenantName;

  /**
   * 计费类型
   */
  @TableField("billingType")
  private String billingType;

  /**
   * 计费项
   */
  @TableField("businessCode")
  private String businessCode;

  /**
   * 原始的合同编号
   */
  @TableField("originContractCode")
  private String originContractCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billCycleId", billCycleId);
      map.put("contractCode", contractCode);
      map.put("productName", productName);
      map.put("productCode", productCode);
      map.put("taxNum", taxNum);
      map.put("companyName", companyName);
      map.put("usageCount", usageCount);
      map.put("billMonth", BocpGenUtils.toTimestamp(billMonth));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("billMonthStr", billMonthStr);
      map.put("taxNumPk", taxNumPk);
      map.put("bTenantCode", bTenantCode);
      map.put("bTenantName", bTenantName);
      map.put("billingType", billingType);
      map.put("businessCode", businessCode);
      map.put("originContractCode", originContractCode);
      return map;
  }

  public static BillDetailMonth fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillDetailMonth entity = new BillDetailMonth();
    if(map.containsKey("billCycleId")) {
      Object obj = map.get("billCycleId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillCycleId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBillCycleId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBillCycleId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("contractCode")) {
      Object obj = map.get("contractCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNum")) {
      Object obj = map.get("taxNum");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("usageCount")) {
      Object obj = map.get("usageCount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUsageCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUsageCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUsageCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUsageCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUsageCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("billMonth")) {
      Object obj = map.get("billMonth");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillMonth(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBillMonth((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBillMonth(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillMonth(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billMonthStr")) {
      Object obj = map.get("billMonthStr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillMonthStr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNumPk")) {
      Object obj = map.get("taxNumPk");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNumPk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantCode")) {
      Object obj = map.get("bTenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantName")) {
      Object obj = map.get("bTenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessCode")) {
      Object obj = map.get("businessCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originContractCode")) {
      Object obj = map.get("originContractCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginContractCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
