package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-04-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChargeMonthData implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 合同编号
   */
  @TableField("contractCode")
  private String contractCode;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 产品编码
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 租户的标识
   */
  @TableField("tenantCode")
  private String tenantCode;

  /**
   * 租户的名称
   */
  @TableField("tenantName")
  private String tenantName;

  /**
   * 公司税号
   */
  @TableField("taxNum")
  private String taxNum;

  /**
   * 公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 服务开通标识
   */
  @TableField("serviceOpenFlag")
  private String serviceOpenFlag;

  /**
   * 结算周期开始时间
   */
  @TableField("startDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;

  /**
   * 结算周期结束时间
   */
  @TableField("endDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endDate;

  /**
   * 使用月份
   */
  @TableField("billMonth")
  private String billMonth;

  /**
   * 计费类型
   */
  @TableField("billingType")
  private String billingType;

  /**
   * 计费项
   */
  @TableField("businessCode")
  private String businessCode;

  /**
   * 计费业务量
   */
  @TableField("usageCount")
  private Long usageCount;

  /**
   * 限制业务量
   */
  @TableField("usageLimitCount")
  private Long usageLimitCount;

  /**
   * 计费金额（不含税）
   */
  @TableField("billAmountWithoutTax")
  private BigDecimal billAmountWithoutTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 售价（不含税
   */
  @TableField("priceUnit")
  private BigDecimal priceUnit;

  /**
   * 付费方式-原始值
   */
  @TableField("paymentType")
  private Long paymentType;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 租户code
   */
  @TableField("bTenantCode")
  private String bTenantCode;

  /**
   * 租户名称
   */
  @TableField("bTenantName")
  private String bTenantName;

  /**
   * 月流水Id
   */
  @TableField("flowId")
  private Long flowId;

  /**
   * 公司税号-PK
   */
  @TableField("taxNumPk")
  private String taxNumPk;

  /**
   * 税号计费开始时间
   */
  @TableField("taxStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxStartDate;

  /**
   * 税号计费结束时间
   */
  @TableField("taxEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxEndDate;

  /**
   * 原始合同编号
   */
  @TableField("originContractCode")
  private String originContractCode;

  /**
   * 付费方式
   */
  @TableField("paymentTypeEnum")
  private String paymentTypeEnum;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractCode", contractCode);
      map.put("productName", productName);
      map.put("productCode", productCode);
      map.put("tenantCode", tenantCode);
      map.put("tenantName", tenantName);
      map.put("taxNum", taxNum);
      map.put("companyName", companyName);
      map.put("serviceOpenFlag", serviceOpenFlag);
      map.put("startDate", BocpGenUtils.toTimestamp(startDate));
      map.put("endDate", BocpGenUtils.toTimestamp(endDate));
      map.put("billMonth", billMonth);
      map.put("billingType", billingType);
      map.put("businessCode", businessCode);
      map.put("usageCount", usageCount);
      map.put("usageLimitCount", usageLimitCount);
      map.put("billAmountWithoutTax", billAmountWithoutTax);
      map.put("taxRate", taxRate);
      map.put("priceUnit", priceUnit);
      map.put("paymentType", paymentType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("bTenantCode", bTenantCode);
      map.put("bTenantName", bTenantName);
      map.put("flowId", flowId);
      map.put("taxNumPk", taxNumPk);
      map.put("taxStartDate", BocpGenUtils.toTimestamp(taxStartDate));
      map.put("taxEndDate", BocpGenUtils.toTimestamp(taxEndDate));
      map.put("originContractCode", originContractCode);
      map.put("paymentTypeEnum", paymentTypeEnum);
      return map;
  }

  public static ChargeMonthData fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ChargeMonthData entity = new ChargeMonthData();
    if(map.containsKey("contractCode")) {
      Object obj = map.get("contractCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantCode")) {
      Object obj = map.get("tenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNum")) {
      Object obj = map.get("taxNum");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceOpenFlag")) {
      Object obj = map.get("serviceOpenFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setServiceOpenFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("endDate")) {
      Object obj = map.get("endDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndDate(null);
      }
    }
    if(map.containsKey("billMonth")) {
      Object obj = map.get("billMonth");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessCode")) {
      Object obj = map.get("businessCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("usageCount")) {
      Object obj = map.get("usageCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUsageCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setUsageCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUsageCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("usageLimitCount")) {
      Object obj = map.get("usageLimitCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUsageLimitCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setUsageLimitCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUsageLimitCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("billAmountWithoutTax")) {
      Object obj = map.get("billAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBillAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("priceUnit")) {
      Object obj = map.get("priceUnit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPriceUnit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPriceUnit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPriceUnit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPriceUnit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPriceUnit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentType((Long)obj);
        } else if(obj instanceof String) {
          entity.setPaymentType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPaymentType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantCode")) {
      Object obj = map.get("bTenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantName")) {
      Object obj = map.get("bTenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowId")) {
      Object obj = map.get("flowId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFlowId((Long)obj);
        } else if(obj instanceof String) {
          entity.setFlowId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFlowId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("taxNumPk")) {
      Object obj = map.get("taxNumPk");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNumPk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxStartDate")) {
      Object obj = map.get("taxStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTaxStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTaxStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxStartDate(null);
      }
    }
    if(map.containsKey("taxEndDate")) {
      Object obj = map.get("taxEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTaxEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTaxEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxEndDate(null);
      }
    }
    if(map.containsKey("originContractCode")) {
      Object obj = map.get("originContractCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginContractCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentTypeEnum")) {
      Object obj = map.get("paymentTypeEnum");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentTypeEnum((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
