package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-05-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class StandingBook implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 交易流水号
   */
  @TableField("tradeNo")
  private String tradeNo;

  /**
   * 交易回款时间
   */
  @TableField("returnedTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime returnedTime;

  /**
   * 交易回款金额
   */
  @TableField("returnMoney")
  private BigDecimal returnMoney;

  /**
   * 交易已认领金额
   */
  @TableField("takenMoney")
  private BigDecimal takenMoney;

  /**
   * 交易对方银行账号
   */
  @TableField("customerBankNo")
  private String customerBankNo;

  /**
   * 发票抬头公司名称
   */
  @TableField("invoiceCompanyName")
  private String invoiceCompanyName;

  /**
   * 发票购方开户行
   */
  @TableField("bankName")
  private String bankName;

  /**
   * 发票购方银行账号
   */
  @TableField("bankNo")
  private String bankNo;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 交易客户名称
   */
  @TableField("customerName")
  private String customerName;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 项目名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 订单编号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * KAM
   */
  private String kam;

  /**
   * kam邮箱
   */
  @TableField("kamEmail")
  private String kamEmail;

  /**
   * kam邮箱发送时间
   */
  @TableField("kamSendEmailTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime kamSendEmailTime;

  /**
   * 台账处理状态
   */
  private String status;

  /**
   * 交易对方户名
   */
  @TableField("accountName")
  private String accountName;

  /**
   * 发票 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 结算统计明细id
   */
  @TableField("billStaticsDetailId")
  private Long billStaticsDetailId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("tradeNo", tradeNo);
      map.put("returnedTime", BocpGenUtils.toTimestamp(returnedTime));
      map.put("returnMoney", returnMoney);
      map.put("takenMoney", takenMoney);
      map.put("customerBankNo", customerBankNo);
      map.put("invoiceCompanyName", invoiceCompanyName);
      map.put("bankName", bankName);
      map.put("bankNo", bankNo);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("customerName", customerName);
      map.put("contractNo", contractNo);
      map.put("productName", productName);
      map.put("orderNo", orderNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("kam", kam);
      map.put("kamEmail", kamEmail);
      map.put("kamSendEmailTime", BocpGenUtils.toTimestamp(kamSendEmailTime));
      map.put("status", status);
      map.put("accountName", accountName);
      map.put("amountWithTax", amountWithTax);
      map.put("billStaticsDetailId", billStaticsDetailId);
      return map;
  }

  public static StandingBook fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    StandingBook entity = new StandingBook();
    if(map.containsKey("tradeNo")) {
      Object obj = map.get("tradeNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnedTime")) {
      Object obj = map.get("returnedTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReturnedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReturnedTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReturnedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReturnedTime(null);
      }
    }
    if(map.containsKey("returnMoney")) {
      Object obj = map.get("returnMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReturnMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("takenMoney")) {
      Object obj = map.get("takenMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTakenMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTakenMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTakenMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTakenMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTakenMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customerBankNo")) {
      Object obj = map.get("customerBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCompanyName")) {
      Object obj = map.get("invoiceCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankName")) {
      Object obj = map.get("bankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankNo")) {
      Object obj = map.get("bankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kam")) {
      Object obj = map.get("kam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kamEmail")) {
      Object obj = map.get("kamEmail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKamEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kamSendEmailTime")) {
      Object obj = map.get("kamSendEmailTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setKamSendEmailTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setKamSendEmailTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setKamSendEmailTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setKamSendEmailTime(null);
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountName")) {
      Object obj = map.get("accountName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("billStaticsDetailId")) {
      Object obj = map.get("billStaticsDetailId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillStaticsDetailId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBillStaticsDetailId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBillStaticsDetailId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }
}
