package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.financialsettlement.entity.ReimbursementBasicBill;

/**
 * <p>
 * 业务招待报销单
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BusinessServeReimbursementBill extends ReimbursementBasicBill {


  /**
   * 关联申请单单号
   */
  @TableField("applyCode")
  private String applyCode;

  /**
   * 关联申请单标题
   */
  @TableField("applyName")
  private String applyName;

  /**
   * 招待事由及招待方式
   */
  @TableField("entertainmentReson")
  private String entertainmentReson;

  /**
   * 申请明细
   */
  @TableField("applyDetails")
  private String applyDetails;

  /**
   * 出差申请单编码
   */
  @TableField("travelCode")
  private String travelCode;

  /**
   * 出差申请单名称
   */
  @TableField("travelName")
  private String travelName;

  /**
   * 实际招待客户人数及职级
   */
  @TableField("entertainmentCustomerAndLevel")
  private String entertainmentCustomerAndLevel;

  /**
   * 备注
   */
  private String remark;

  /**
   * 预计招待客户人数及职级
   */
  @TableField("estimateCustomerAndLevel")
  private String estimateCustomerAndLevel;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("applyCode", applyCode);
      map.put("applyName", applyName);
      map.put("entertainmentReson", entertainmentReson);
      map.put("applyDetails", applyDetails);
      map.put("travelCode", travelCode);
      map.put("travelName", travelName);
      map.put("entertainmentCustomerAndLevel", entertainmentCustomerAndLevel);
      map.put("remark", remark);
      map.put("estimateCustomerAndLevel", estimateCustomerAndLevel);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static BusinessServeReimbursementBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BusinessServeReimbursementBill entity = new BusinessServeReimbursementBill();
    if(map.containsKey("reimbursementDate")) {
      Object obj = map.get("reimbursementDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReimbursementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReimbursementDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReimbursementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setReimbursementDate(null);
      }
    }
    if(map.containsKey("reimbursementDept")) {
      Object obj = map.get("reimbursementDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReimbursementDept((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bank")) {
      Object obj = map.get("bank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBank((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account")) {
      Object obj = map.get("account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("userComNo")) {
      Object obj = map.get("userComNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUserComNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("userComeName")) {
      Object obj = map.get("userComeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUserComeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyCode")) {
      Object obj = map.get("applyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entertainmentReson")) {
      Object obj = map.get("entertainmentReson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntertainmentReson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyDetails")) {
      Object obj = map.get("applyDetails");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyDetails((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("travelCode")) {
      Object obj = map.get("travelCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTravelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("travelName")) {
      Object obj = map.get("travelName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTravelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entertainmentCustomerAndLevel")) {
      Object obj = map.get("entertainmentCustomerAndLevel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntertainmentCustomerAndLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("estimateCustomerAndLevel")) {
      Object obj = map.get("estimateCustomerAndLevel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEstimateCustomerAndLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
