package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinBasicBill;

/**
 * <p>
 * 报销基础单据
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReimbursementBasicBill extends FinBasicBill {


  /**
   * 报销日期
   */
  @TableField("reimbursementDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reimbursementDate;

  /**
   * 报销部门
   */
  @TableField("reimbursementDept")
  private String reimbursementDept;

  /**
   * 收款银行
   */
  private String bank;

  /**
   * 收款账号
   */
  private String account;

  /**
   * 收款人
   */
  private String payee;

  /**
   * 报销人所属公司编码
   */
  @TableField("userComNo")
  private String userComNo;

  /**
   * 报销人所属公司名称
   */
  @TableField("userComeName")
  private String userComeName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("reimbursementDate", BocpGenUtils.toTimestamp(reimbursementDate));
      map.put("reimbursementDept", reimbursementDept);
      map.put("bank", bank);
      map.put("account", account);
      map.put("payee", payee);
      map.put("userComNo", userComNo);
      map.put("userComeName", userComeName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static ReimbursementBasicBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReimbursementBasicBill entity = new ReimbursementBasicBill();
    if(map.containsKey("applicatNo")) {
      Object obj = map.get("applicatNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicatNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicatName")) {
      Object obj = map.get("applicatName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicatName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("peerCode")) {
      Object obj = map.get("peerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPeerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("peersName")) {
      Object obj = map.get("peersName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPeersName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessTrip")) {
      Object obj = map.get("businessTrip");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessTrip((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costCenterCode")) {
      Object obj = map.get("costCenterCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenterCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costCenterName")) {
      Object obj = map.get("costCenterName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenterName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectAreaCode")) {
      Object obj = map.get("projectAreaCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectAreaCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectAreaName")) {
      Object obj = map.get("projectAreaName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectAreaName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kamCode")) {
      Object obj = map.get("kamCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKamCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kamName")) {
      Object obj = map.get("kamName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKamName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("leaderCode")) {
      Object obj = map.get("leaderCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLeaderCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("leaderName")) {
      Object obj = map.get("leaderName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLeaderName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectTypeCode")) {
      Object obj = map.get("projectTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectTypeName")) {
      Object obj = map.get("projectTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ownerCode")) {
      Object obj = map.get("ownerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwnerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ownerName")) {
      Object obj = map.get("ownerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwnerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeBudgetTypeCode")) {
      Object obj = map.get("chargeBudgetTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeBudgetTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeBudgetTypeName")) {
      Object obj = map.get("chargeBudgetTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeBudgetTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("staffMaill")) {
      Object obj = map.get("staffMaill");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStaffMaill((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reimbursementDate")) {
      Object obj = map.get("reimbursementDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReimbursementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReimbursementDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReimbursementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReimbursementDate(null);
      }
    }
    if(map.containsKey("reimbursementDept")) {
      Object obj = map.get("reimbursementDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReimbursementDept((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bank")) {
      Object obj = map.get("bank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account")) {
      Object obj = map.get("account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userComNo")) {
      Object obj = map.get("userComNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUserComNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userComeName")) {
      Object obj = map.get("userComeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUserComeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
