package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.financialsettlement.entity.ShareInfo;

/**
 * <p>
 * 差旅报销单明细
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TravelBillDetail extends ShareInfo {


  /**
   * 同行人编码
   */
  @TableField("peerCode")
  private String peerCode;

  /**
   * 同行人名称
   */
  @TableField("peerName")
  private String peerName;

  /**
   * 费用日期
   */
  @TableField("costDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime costDate;

  /**
   * 订单金额
   */
  @TableField("orderAmount")
  private BigDecimal orderAmount;

  /**
   * 消费开始日期
   */
  @TableField("startCostDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startCostDate;

  /**
   * 消费结束日期
   */
  @TableField("endCostDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endCostDate;

  /**
   * 停车开始日期
   */
  @TableField("startParkDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startParkDate;

  /**
   * 停车结束日期
   */
  @TableField("endParkDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endParkDate;

  /**
   * 出差开始日期
   */
  @TableField("startEvectionDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startEvectionDate;

  /**
   * 出差结束日期
   */
  @TableField("endEvectionDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endEvectionDate;

  /**
   * 是否分摊
   */
  private String share;

  /**
   * 结算方式
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 火车票号码
   */
  @TableField("trainTicketNo")
  private String trainTicketNo;

  /**
   * 发票张数
   */
  @TableField("invoiceCount")
  private String invoiceCount;

  /**
   * 登机牌
   */
  @TableField("boardingPass")
  private String boardingPass;

  /**
   * 保险费
   */
  @TableField("insuranceAmount")
  private String insuranceAmount;

  /**
   * 消费城市
   */
  @TableField("costCity")
  private String costCity;

  /**
   * 停车地点
   */
  @TableField("parkPosition")
  private String parkPosition;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("peerCode", peerCode);
      map.put("peerName", peerName);
      map.put("costDate", BocpGenUtils.toTimestamp(costDate));
      map.put("orderAmount", orderAmount);
      map.put("startCostDate", BocpGenUtils.toTimestamp(startCostDate));
      map.put("endCostDate", BocpGenUtils.toTimestamp(endCostDate));
      map.put("startParkDate", BocpGenUtils.toTimestamp(startParkDate));
      map.put("endParkDate", BocpGenUtils.toTimestamp(endParkDate));
      map.put("startEvectionDate", BocpGenUtils.toTimestamp(startEvectionDate));
      map.put("endEvectionDate", BocpGenUtils.toTimestamp(endEvectionDate));
      map.put("share", share);
      map.put("paymentType", paymentType);
      map.put("trainTicketNo", trainTicketNo);
      map.put("invoiceCount", invoiceCount);
      map.put("boardingPass", boardingPass);
      map.put("insuranceAmount", insuranceAmount);
      map.put("costCity", costCity);
      map.put("parkPosition", parkPosition);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static TravelBillDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TravelBillDetail entity = new TravelBillDetail();
    if(map.containsKey("shareProjectCode")) {
      Object obj = map.get("shareProjectCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShareProjectCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shareProjectName")) {
      Object obj = map.get("shareProjectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShareProjectName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shareProportion")) {
      Object obj = map.get("shareProportion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareProportion((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareProportion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareProportion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setShareProportion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareProportion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("shareAmount")) {
      Object obj = map.get("shareAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setShareAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("peerCode")) {
      Object obj = map.get("peerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPeerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("peerName")) {
      Object obj = map.get("peerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPeerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costDate")) {
      Object obj = map.get("costDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCostDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCostDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCostDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCostDate(null);
      }
    }
    if(map.containsKey("orderAmount")) {
      Object obj = map.get("orderAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("startCostDate")) {
      Object obj = map.get("startCostDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartCostDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartCostDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartCostDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartCostDate(null);
      }
    }
    if(map.containsKey("endCostDate")) {
      Object obj = map.get("endCostDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndCostDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndCostDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndCostDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndCostDate(null);
      }
    }
    if(map.containsKey("startParkDate")) {
      Object obj = map.get("startParkDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartParkDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartParkDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartParkDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartParkDate(null);
      }
    }
    if(map.containsKey("endParkDate")) {
      Object obj = map.get("endParkDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndParkDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndParkDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndParkDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndParkDate(null);
      }
    }
    if(map.containsKey("startEvectionDate")) {
      Object obj = map.get("startEvectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartEvectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartEvectionDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartEvectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartEvectionDate(null);
      }
    }
    if(map.containsKey("endEvectionDate")) {
      Object obj = map.get("endEvectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndEvectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndEvectionDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndEvectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndEvectionDate(null);
      }
    }
    if(map.containsKey("share")) {
      Object obj = map.get("share");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShare((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trainTicketNo")) {
      Object obj = map.get("trainTicketNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTrainTicketNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCount")) {
      Object obj = map.get("invoiceCount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("boardingPass")) {
      Object obj = map.get("boardingPass");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBoardingPass((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("insuranceAmount")) {
      Object obj = map.get("insuranceAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInsuranceAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCity")) {
      Object obj = map.get("costCity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parkPosition")) {
      Object obj = map.get("parkPosition");
      if(obj != null) {
        if(obj instanceof String){
          entity.setParkPosition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
